#version 330
#extension GL_EXT_gpu_shader4 : enable
//LearnRayMarchingGN  by   bibiGN
//https://www.shadertoy.com/view/wls3Wf
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

mat2 rotation(float radian)
{
    float c = cos(radian);
    float s = sin(radian);
    return mat2(c, s, -s, c);
}

float sphere(vec3 pos, float radius)
{
    return length(pos) - radius;
}
float cylinder(vec3 pos, float radius)
{
    return length(pos.xy) - radius;
}
float box(vec3 pos, float radius)
{
    pos = abs(pos);
    return max(pos.x, max(pos.y, pos.z)) - radius;
}


float map(vec3 pos)
{
    //pos.z += iTime;
    pos.xy *= rotation(pos.z * 0.2);
    pos.z += iTime * .5;	
    //pos.yz *= rotation(iTime*0.05);
    
    float size = 2.5;
    pos = mod(pos, size) - size/2.;
    
    float s = sphere(pos, 0.75);
    float b = box(pos, 0.6);
    float geometry =  max(s, b);
    geometry = min(geometry, cylinder(pos, 0.3));
    geometry = min(geometry, cylinder(pos.xzy, 0.3));
    geometry = min(geometry, cylinder(pos.zyx, 0.3));
    return geometry;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    uv = uv * 2. - 1.;
    uv.x *= iResolution.x / iResolution.y;
    
    float circle = length(uv) - 0.5;
    circle = step(0.4, circle);
    
    vec3 eye = vec3(0., 0., -2.);
    vec3 ray = normalize(vec3(uv, 1.));
    float shade = 0.;
    int nbLoop = 20;
    for (int i = 0; i < nbLoop; ++i)
    {
        float dist = map(eye);
        if (dist < 0.001)
        {
            shade = 1. - float(i)/float(nbLoop);
            break;
        }
        eye += ray * dist;
    }
    
    gl_FragColor = vec4(shade);
}
